<?php
/*
Plugin Name: Inventive Overrides 
Description: The Inventive Plugin: Changes dashboard colours, whitelabels WP + removes plugin bloat!
Version: 1.2.1
Author: Inventive - Web | Print | Digital Marketing
Author URI: https://www.inventivedesign.co.uk
*/

///////////////////////////////////
// Custom Login+Dashboard Styles //
///////////////////////////////////

function inventive_admin_styles() {
	wp_enqueue_style( 'inventive-admin', plugins_url( '/css/inventive-admin.css', __FILE__ ) );
}

add_action( 'login_enqueue_scripts', 'inventive_admin_styles');
add_action( 'admin_enqueue_scripts', 'inventive_admin_styles');

//END

//////////////////////////////////////
// Pointing Login Logo at Inventive //
/////////////////////////////////////

function theme_slug_logo_url() {
    return 'https://www.inventivedesign.co.uk';
}

add_filter( 'login_headerurl', 'theme_slug_logo_url' );

// END


/////////////////////////////////
// Change WP Footer Throughout //
/////////////////////////////////

function wpse_edit_footer() {
    add_filter( 'admin_footer_text', 'wpse_edit_text', 11 );
}

function wpse_edit_text($content) {
    echo "<a href='https://www.inventivedesign.co.uk".$link_address."' target='_blank' >Website by Inventive</a>";
}

add_action( 'admin_init', 'wpse_edit_footer' );
add_filter( 'login_headerurl', 'custom_loginlogo_url' );

function custom_loginlogo_url($url) {
    return 'http://www.inventivedesign.co.uk';
}

// END WP FOOTER


////////////////////////////////////
// Remove Yoast Bloat Throughout //
///////////////////////////////////

add_action( 'template_redirect', function () {
 
    if ( ! class_exists( 'WPSEO_Frontend' ) ) {
        return;
    }
 
    $instance = WPSEO_Frontend::get_instance();
 
    // make sure, future version of the plugin does not break our site.
    if ( ! method_exists( $instance, 'debug_mark') ) {
        return ;
    }
 
    // ok, let us remove the love letter.
     remove_action( 'wpseo_head', array( $instance, 'debug_mark' ), 2 );
}, 9999 );



// END

//////////////////////////////
// Wordpress Dashboard Area //
//////////////////////////////

add_action('wp_dashboard_setup', 'my_custom_dashboard_widgets');
  
function my_custom_dashboard_widgets() {
global $wp_meta_boxes;
 
wp_add_dashboard_widget('custom_help_widget', 'Website Support From Inventive', 'custom_dashboard_help');
}
 
function custom_dashboard_help() {
echo '<p>Need help with your website?</p>
<p> <span class="dashicons dashicons-email"></span><a href="mailto:support@inventivedesign.co.uk"> Email the team at Inventive </a></p><p><span class="dashicons dashicons-phone"></span> Call us on <strong>01271 325870.</strong></p>
<p><span class="dashicons dashicons-admin-site"></span> <a href="https://www.inventivedesign.co.uk" target="_blank">Visit our website</a></p>';
}

// END

?>