<?php
/**
 * Plugin Name: Wrapper Block
 * Description: Wrapper block for Gutenberg in WordPress.
 * Author: Daniel Thorne
 * Author URI: https://www.inventivedesign.co.uk
 * Version: 1.0.0
 * License: GPL2+
 * License URI: https://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: wrapper-block
 * Domain Path: /languages/
 *
 * @package wrapper-block
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'enqueue_block_editor_assets', 'wrapper_block_enqueue_block_editor_assets' );

function wrapper_block_enqueue_block_editor_assets() {
    // Enqueue our script
    wp_enqueue_script(
        'wrapper-block-js',
        esc_url( plugins_url( '/dist/wrapper-block.js', __FILE__ ) ),
        array( 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-editor' ),
        '1.0.0',
        true // Enqueue the script in the footer.
    );
}
