<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package understrap
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

get_header();

$container = get_theme_mod( 'understrap_container_type' );

?>

<div class="wrapper" id="page-wrapper">

	<div class="<?php echo esc_attr( $container ); ?>" id="content" tabindex="-1">

		<div class="row">

			<main class="site-main" id="main">
            
				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'loop-templates/content', 'page' ); ?>

				<?php endwhile; // end of the loop. ?>

        <div class="quicklinks">
          <div class="row">

            <div class="col-md-6">
              <?php $quicklink_1 = get_field('quicklink_1', false, false); ?>
              <?php if( $quicklink_1 ): ?>
                <a href="<?php echo get_the_permalink($quicklink_1); ?>" class="quicklink quicklink-single">
                  <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id($quicklink_1), 'large-square' ); ?>
                  <img src="<?php echo $image[0]; ?>" alt="" />
                  <div class="quicklink-title"><?php echo get_the_title($quicklink_1); ?></div>
                </a>
              <?php endif; ?>
            </div>

            <div class="col-md-6 no-margin">

              <div class="quicklink-grid">
                <div class="row">

                  <div class="col-md-6">
                    <?php $quicklink_2 = get_field('quicklink_2', false, false); ?>
                    <?php if( $quicklink_2 ): ?>
                      <a href="<?php echo get_the_permalink($quicklink_2); ?>" class="quicklink">
                        <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id($quicklink_2), 'square' ); ?>
                        <img src="<?php echo $image[0]; ?>" alt="" />
                        <div class="quicklink-title"><?php echo get_the_title($quicklink_2); ?></div>
                      </a>
                    <?php endif; ?>
                  </div>

                  <div class="col-md-6">
                    <?php $quicklink_3 = get_field('quicklink_3', false, false); ?>
                    <?php if( $quicklink_3 ): ?>
                      <a href="<?php echo get_the_permalink($quicklink_3); ?>" class="quicklink">
                        <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id($quicklink_3), 'square' ); ?>
                        <img src="<?php echo $image[0]; ?>" alt="" />
                        <div class="quicklink-title"><?php echo get_the_title($quicklink_3); ?></div>
                      </a>
                    <?php endif; ?>
                  </div>

                  <div class="col-md-6">
                    <?php $quicklink_4 = get_field('quicklink_4', false, false); ?>
                    <?php if( $quicklink_4 ): ?>
                      <a href="<?php echo get_the_permalink($quicklink_4); ?>" class="quicklink">
                        <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id($quicklink_4), 'square' ); ?>
                        <img src="<?php echo $image[0]; ?>" alt="" />
                        <div class="quicklink-title"><?php echo get_the_title($quicklink_4); ?></div>
                      </a>
                    <?php endif; ?>
                  </div>

                  <div class="col-md-6">
                    <?php $quicklink_5 = get_field('quicklink_5', false, false); ?>
                    <?php if( $quicklink_5 ): ?>
                      <a href="<?php echo get_the_permalink($quicklink_5); ?>" class="quicklink">
                        <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id($quicklink_5), 'square' ); ?>
                        <img src="<?php echo $image[0]; ?>" alt="" />
                        <div class="quicklink-title"><?php echo get_the_title($quicklink_5); ?></div>
                      </a>
                    <?php endif; ?>
                  </div>

                </div>

              </div>
            </div>

          </div>
        </div>

        <div id="featured-news" class="text-image-strap">

        <?php
        $args = array( 'numberposts' => 1, 'order' => 'DESC', 'orderby' => 'date', 'category' => 1 );
        $postslist = get_posts($args);

        foreach ($postslist as $post) :
            setup_postdata($post);
        ?>
          <div class="row no-gutters">
            <div class="col-lg-5">
              <div class="image-strap-text">
                <h2>Latest News</h2>
                <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                <p><?php the_excerpt(); ?></p>
              </div>
            </div>

            <div class="col-lg-7">
              <div class="image-strap-image">
                <img src="<?php the_post_thumbnail_url( array(1200, 1200) ); ?>" alt="<?php the_title(); ?>">
                <a class="more-link" href="/news">More News</a>
              </div>
            </div>
          </div>
          <?php endforeach; ?>

        </div>

      </main><!-- #main -->

    </div><!-- .row -->

	</div><!-- #content -->

</div><!-- #page-wrapper -->

<?php get_footer();
