<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function understrap_remove_scripts() {
    wp_dequeue_style( 'understrap-styles' );
    wp_deregister_style( 'understrap-styles' );

    wp_dequeue_script( 'understrap-scripts' );
    wp_deregister_script( 'understrap-scripts' );

    // Removes the parent themes stylesheet and scripts from inc/enqueue.php
}
add_action( 'wp_enqueue_scripts', 'understrap_remove_scripts', 20 );

add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {

	// Get the theme data
	$the_theme = wp_get_theme();
    wp_enqueue_style( 'child-understrap-styles', get_stylesheet_directory_uri() . '/css/child-theme.min.css', array(), $the_theme->get( 'Version' ) );
    wp_enqueue_style('cookie-consent', '//cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.1.0/cookieconsent.min.css', false);

    wp_enqueue_script( 'jquery');
    wp_enqueue_script( 'child-understrap-scripts', get_stylesheet_directory_uri() . '/js/child-theme.min.js', array(), $the_theme->get( 'Version' ), true );
    wp_enqueue_script('main-scripts', get_stylesheet_directory_uri() . '/js/main.js', array(), $the_theme->get('Version'), TRUE);
    wp_enqueue_script('cookie-consent-scripts', '//cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.1.0/cookieconsent.min.js', array(), false, true);

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}

function add_child_theme_textdomain() {
    load_child_theme_textdomain( 'understrap-child', get_stylesheet_directory() . '/languages' );
}
add_action( 'after_setup_theme', 'add_child_theme_textdomain' );





// Register footer menu
function register_footer_menu()
{
register_nav_menu('footer-menu', __('Footer Menu'));
}
add_action('init', 'register_footer_menu');




// Register custom image sizes
add_image_size( 'square', 800, 800, true ); 
add_image_size( 'large-square', 1200, 1200, true );
//add_image_size( 'news-preview', 410, 270, true );




// Remove unneeded sections from customiser
function prefix_remove_section( $wp_customize ) {
$wp_customize->remove_section( 'custom_css' );
$wp_customize->remove_section( 'understrap_theme_layout_options' );
$wp_customize->remove_section( 'colors' );
$wp_customize->remove_section( 'background_image' );
}
add_action( 'customize_register', 'prefix_remove_section', 15 );








add_action('acf/init', 'my_acf_init');
function my_acf_init() {
	
	// check function exists
	if( function_exists('acf_register_block') ) {
		
		// register a testimonial block
		acf_register_block(array(
			'name'				=> 'testimonial',
			'title'				=> __('Testimonial'),
			'description'		=> __('A custom testimonial block.'),
			'render_callback'	=> 'my_acf_block_render_callback',
			'category'			=> 'formatting',
			'icon'				=> 'admin-comments',
			'keywords'			=> array( 'testimonial', 'quote' ),
		));
	}
}


function my_acf_block_render_callback( $block ) {
	
	// convert name ("acf/testimonial") into path friendly slug ("testimonial")
	$slug = str_replace('acf/', '', $block['name']);
	
	// include a template part from within the "template-parts/block" folder
	if( file_exists( get_theme_file_path("/block-templates/content-{$slug}.php") ) ) {
		include( get_theme_file_path("/block-templates/content-{$slug}.php") );
	}
}





// Override
add_filter( 'wp_trim_excerpt', 'understrap_all_excerpts_get_more_link' );

if ( ! function_exists( 'understrap_all_excerpts_get_more_link' ) ) {
	/**
	 * Adds a custom read more link to all excerpts, manually or automatically generated
	 *
	 * @param string $post_excerpt Posts's excerpt.
	 *
	 * @return string
	 */
	function understrap_all_excerpts_get_more_link( $post_excerpt ) {
		if ( ! is_admin() ) {
			$post_excerpt = $post_excerpt . ' [...]<p><a class="btn btn-primary understrap-read-more-link" href="' . esc_url( get_permalink( get_the_ID() ) ) . '">' . __( 'Read More...',
			'understrap' ) . '</a></p>';
		}
		return $post_excerpt;
	}
}

// ACF Block 
function register_acf_blocks() {

	// Text left/right Image right/left Block
	acf_register_block_type(array(
        'name'              => 'text-image',
        'title'             => __('Text and Image'),
        'description'       => __('Text and Image Block'),
        'render_template'   => 'template-parts/blocks/text-image/text-image.php',
        'category'          => 'formatting',
        'icon'              => 'analytics',
		'keywords'          => array( 'text', 'image', 'content' ),
		'mode'				=> 'edit'
	));

	// Text left/right Video right/left Block
	acf_register_block_type(array(
        'name'              => 'text-video',
        'title'             => __('Text and Video'),
        'description'       => __('Text and Video Block'),
        'render_template'   => 'template-parts/blocks/text-video/text-video.php',
        'category'          => 'formatting',
        'icon'              => 'playlist-video',
		'keywords'          => array( 'text', 'video', 'content' ),
		'mode'				=> 'edit'
	));

	// Text left/right HTML right/left Block
	acf_register_block_type(array(
        'name'              => 'html-image',
        'title'             => __('Text and HTML'),
        'description'       => __('Text and HTML Block'),
        'render_template'   => 'template-parts/blocks/html-image/html-image.php',
        'category'          => 'formatting',
        'icon'              => 'editor-code',
		'keywords'          => array( 'text', 'html', 'content' ),
		'mode'				=> 'edit'
	));


}

if( function_exists('acf_register_block_type') ) {
	add_action('acf/init', 'register_acf_blocks');
}