<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package understrap
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

get_header();

$container = get_theme_mod( 'understrap_container_type' );

?>







<div class="wrapper" id="page-wrapper">

	<div class="<?php echo esc_attr( $container ); ?>" id="content" tabindex="-1">

		<div class="row">


			<main class="site-main" id="main">

				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'loop-templates/content', 'page' ); ?>

				<?php endwhile; // end of the loop. ?>


				<div id="news">
					<div class="row">

						<?php
							$btpgid=get_queried_object_id();
							$btmetanm=get_post_meta( $btpgid, 'WP_Catid','true' );
							$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

							$args = array( 'posts_per_page' => 12, 'category_name' => $btmetanm,
							'paged' => $paged,'post_type' => 'post' );
							$postslist = new WP_Query( $args );

							if ( $postslist->have_posts() ) :
								while ( $postslist->have_posts() ) : $postslist->the_post(); 
						?>

							<div class="col-lg-6 col-xl-4">
								<a href="<?php the_permalink(); ?>">
									<img src="<?php the_post_thumbnail_url( array(1200, 1200, true) ); ?>" alt="<?php the_title(); ?>">
									<h3><?php the_title(); ?></h3>
								</a>
							</div>
							
						<?php
								endwhile;  
							next_posts_link( 'Older Entries', $postslist->max_num_pages );
							previous_posts_link( 'Next Entries &raquo;' ); 
							wp_reset_postdata();
							endif;
						?>

					</div>
				</div>

			</main><!-- #main -->


		</div><!-- .row -->

	</div><!-- #content -->

</div><!-- #page-wrapper -->

<?php get_footer();
