<?php
/**
 * Block template for HTML left / right IMAGE right / left
 */

 // Anchor Value
 $id = 'htmlimage-' . $block['id'];
 if( !empty($block['anchor']) ) {
     $id = $block['anchor'];
 }

 // Classname
 $className = 'html-image';

 if( !empty($block['className'] ) ) {
     $className .= ' ' . $block['className'];
 }

 // Get fields
 $position = get_field('position');
 $image = get_field('image');
 $html = get_field('html');

 if( $position == 'left') {
     ?>
        <div class="text-image-strap image-right-text-left textblock">
            <div class="row no-gutters">
                <div class="col-lg-5 order-2 order-md-2">
                    <div class="image-strap-text custom-html">
                        <?php echo $html ?>
                    </div>
                </div>

                <div class="col-lg-7 order-1 order-md-2">
                    <div class="image-strap-image">
                        <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />                    
                    </div>
                </div>
            </div>
        </div>
    <?php
 }

 if( $position == 'right' ) {
     ?>
        <div class="text-image-strap green image-left-text-right textblock">
            <div class="row no-gutters">
                <div class="col-lg-7 order-1 order-md-1">
                    <div class="image-strap-image">
                        <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" /> 
                    </div>
                </div>

                <div class="col-lg-5 order-2 order-md-2">
                    <div class="image-strap-text custom-html">                      
                        <?php echo $html ?>
                    </div>                   
                </div>
            </div>
        </div>
     <?php
 }