<?php
/**
 * Block Template for Text Left / Image Right or Text Right / Image Left
 */

// Custom Anchor value
$id = 'textimage-' . $block['id'];
if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
}

// ClassName
$className = 'textimage';

if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
}

// Load values from ACF. 
$position = get_field('position');
$image = get_field('image');
$text = get_field('text');

if( $position == "left" ) {
    // Text Left, Image Right
    ?>
        <div class="text-image-strap image-right-text-left textblock">
            <div class="row no-gutters">
                <div class="col-lg-5 order-2 order-md-2">
                    <div class="image-strap-text">
                        <?php echo $text ?>
                    </div>
                </div>

                <div class="col-lg-7 order-1 order-md-2">
                    <div class="image-strap-image">
                        <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />                    
                    </div>
                </div>
            </div>
        </div>
    <?php
}

if( $position == "right" ) {
    // Text Right, Image Left. 
    ?>
        <div class="text-image-strap green image-left-text-right textblock">
            <div class="row no-gutters">
                <div class="col-lg-7 order-1 order-md-1">
                    <div class="image-strap-image">
                        <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" /> 
                    </div>
                </div>

                <div class="col-lg-5 order-2 order-md-2">
                    <div class="image-strap-text">                      
                        <?php echo $text ?>
                    </div>                   
                </div>
            </div>
        </div>
    <?php 
}