<?php
/**
 * Block Template for Text Left / Video Right or 
 */

// Anchor Value
$id = 'textvideo-' . $block['id'];
if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
}

// Class
$className = 'textvideo';
if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
}

// ACF Variables
$position = get_field('position');
$video = get_field('video');
$text = get_field('text');

// Display options

if( $position == 'left' ) {
    // Text Left, Video Right
    ?>
        <div class="text-image-strap image-right-text-left textblock">
            <div class="row no-gutters">
                <div class="col-lg-5 order-2 order-md-2">
                    <div class="image-strap-text">
                        <?php echo $text ?>
                    </div>
                </div>

                <div class="col-lg-7 order-1 order-md-2">
                    <div class="image-strap-image video">
                        <div class="video-wrapper">
                            <?php echo $video ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php
}

if( $position == 'right' ) {
    // Video Left, Text Right
    ?>
        <div class="text-image-strap green image-left-text-right textblock">
            <div class="row no-gutters">
                <div class="col-lg-7 order-1 order-md-1">
                    <div class="image-strap-image video">
                        <div class="video-wrapper">
                            <?php echo $video ?>
                        </div>
                    </div>
                </div>

                <div class="col-lg-5 order-2 order-md-2">
                    <div class="image-strap-text">
                        <?php echo $text ?>
                    </div>
                </div>
            </div>
        </div>
    <?php
}